; doline
; setup:
; xsave,ysave is the center
; linelen gives length
doline:
 clrw			; 0 rotation
 call doarrowld		; load offset
 movf xsave,w		; last X
 movwf hcenter		; center
 subwf ysave,w		; Y-X
 movwf Ydelp		; into Ydelp
 movf linelen,w		; load length
 movwf count
 call doarrowlp
 return

doharrow:
 movlw 0x80
 movwf xsave
 movwf ysave
 
 movlw 0x14		; 120deg rotation
 call doside

 movlw 0x3A		; -12deg rotation
 movwf rotn
 call dolength

 movlw 0x20		; +192deg rotation
 movwf rotn
 call dolength

 movlw 0x0A		; -120deg rotation
 call doside
 return

; doarrow
; setup:
; baselen gives length of base
; linelen gives height of triangle
domarrow:
 movlw 0x80
 movwf xsave
 movwf ysave
 
 movlw 0x14		; 120deg rotation
 call doside

 clrf rotn		; average of 0 and
 movlw 0x3B		; -6deg rotation
 call dolength
 
 movlw 0x1E		; average of +180 and
 movwf rotn		; ...
 movlw 0x1F		; +186deg rotation
 call dolength

 movlw 0x0A		; -120deg rotation
 call doside
 return

doside:
 call doarrowld		; get the offsets
 movf xsave,w		; last X
 movwf hcenter		; center
 subwf ysave,w		; Y-X
 movwf Ydelp		; into Ydelp
 bcf STATUS,C		; clear status
 btfsc Xsign		; if Xsign==1
 bsf STATUS,C		; set carry
 rrf xoff,f		; divide xoff by 2
 bcf STATUS,C		; clear status
 btfsc Ysign		; if Ysign==1
 bsf STATUS,C		; set carry
 rrf yoff,f		; divide yoff by 2
 movf baselen,w		; Ydelm is the lateral displacement
 movwf count
 call doarrowlp
 return

dolength:
 call doarrowld		; get the offsets
 movf xsave,w		; last X
 movwf hcenter		; center
 subwf ysave,w		; Y-X
 movwf Ydelp		; into Ydelp
 movf xoff,w		; load xoff
 movwf xsave		; save it
 movf yoff,w		; load yoff
 movwf ysave		; save it
 movf rotn,w		; other rotation
 call doarrowld		; get offsets
 clrf xh		; clear high byte
 btfsc Xssgn		; xsave<0?
 decf xh,f		; sign extend
 btfsc Xsign		; xoff<0?
 decf xh,f		; sign extend
 movf xsave,w		; load old xoff
 addwf xoff,f		; add to new offset
 btfsc STATUS,C		; if carry
 incf xh,f		; add it to the high byte
 bcf STATUS,C		; clear carry
 btfsc xh,0x00		; if xh[0]==1
 bsf STATUS,C		; set carry appropriately
 rrf xoff,f		; divide by two
 bcf Xsign		; clear sign
 btfsc xh,0x01		; if xh[1]==1
 bsf Xsign		; we're negative
 clrf yh		; clear high byte
 btfsc Yssgn		; ysave<0?
 decf yh,f		; sign extend
 btfsc Ysign		; yoff<0?
 decf yh,f		; sign extend
 movf ysave,w		; load old yoff
 addwf yoff,f		; add to new offset
 btfsc STATUS,C		; if carry
 incf yh,f		; add to the high byte
 bcf STATUS,C		; clear carry
 btfsc yh,0x00		; if yh[0]==1
 bsf STATUS,C		; set carry appropriately
 rrf yoff,f		; divide by two
 bcf Ysign		; clear sign
 btfsc yh,0x01		; if yh[1]==1
 bsf Ysign		; we're negative
 movf linelen,w		; linelen is the length of the arrow
 movwf count
 call doarrowlp
 return

doarrowld:
 addwf hand,w		; read the hand
 addlw 0xC4		; w-60
 btfss STATUS,C		; unless the answer is >= 0
 addlw 0x3C		; add 60 back
 movwf temp		; save this
 rlf sign,f		; rotate sign
 rlf sign,f		; rotate sign
 bcf Xsign		; clear X
 bcf Ysign		; clear Y
 addlw 0xE1		; w-31
 btfsc STATUS,C		; did we carry?
 bsf Xsign		; yes: x is negative
 movf temp,w		; load hand again
 addlw 0xF0		; subtract 16
 btfss STATUS,C		; did we carry?
 goto $ + 0x05		; no: y < 15
 movf temp,w		; load hand again
 addlw 0xD3		; subtract 45
 btfss STATUS,C		; did we carry?
 bsf Ysign		; no: y is negative
 movf temp,w		; the address to load
 bsf STATUS,RP0		; bank 1
 movwf EEADR		; write this to eeadr
 bsf EECON1,RD		; read it
 movf EEDATA,w		; into w
 movwf xoff		; write it
 movlw 0x40		; 64 +
 addwf EEADR,f		; write address
 bsf EECON1,RD		; read it
 movf EEDATA,w		; into w
 movwf yoff		; write it
 bcf STATUS,RP0		; bank 0
 return

doarrowlp:
 clrf xl		; ...
 clrf yl		; ...
 clrf xh		; ...
 clrf yh		; ...
 movf hcenter,w		; load center
 call writeX		; x
 beamoff		; turn off the beam before moving
 call writeY		; y
 beamon			; now turn it back on

doarrow1:
 decfsz count,f		; decrement count
 goto $ + 0x02		; jump around or...
 return			; we've hit 0 and we're done
 
 movf xoff,w		; load xoff
 addwf xl,f		; add to the present position
 btfsc STATUS,C		; if carry is set
 incf xh,f		; increment the high byte
 btfsc Xsign		; if the increment is negative
 decf xh,f		; add 0xFF to the high byte
 rlf xh,w		; rotate, ->w
 movwf temp		; write to temp
 rlf temp,w		; rotate, ->w
 andlw 0xFC		; mask off bottom two bits
 btfsc xl,0x07		; if (xl[7])
 iorlw 0x02		; xh[1]=1
 btfsc xl,0x06		; if (xl[6])
 iorlw 0x01		; xh[0]=1
 addwf hcenter,w	; add center offset
 movwf xsave		; save x
 call writeX		; w is ready

 movf yoff,w		; load xoff
 addwf yl,f		; add to the present position
 btfsc STATUS,C		; if carry is set
 incf yh,f		; increment the high byte
 btfsc Ysign		; if the increment is negative
 decf yh,f		; add 0xFF to the high byte
 rlf yh,w		; rotate, ->w
 movwf temp		; write to temp
 rlf temp,w		; rotate, ->w
 andlw 0xFC		; mask off bottom two bits
 btfsc yl,0x07		; if (xl[7])
 iorlw 0x02		; yh[1]=1
 btfsc yl,0x06		; if (xl[6])
 iorlw 0x01		; yh[0]=1
 addwf hcenter,w	; add center offset
 addwf Ydelp,w		; add Y offset
 movwf ysave		; save y
 call writeY		; w is ready

 goto doarrow1		; lather, rinse, repeat
