; interrupt routine

intrh:
 ;movwf wsave		; save w
 ;swapf STATUS,w		; load STATUS
 bcf STATUS,RP0		; bank 0
 bcf STATUS,RP1		; ...
 ;movwf tsave		; save status
 ;bsf LDbar		; not LDing
 ;bsf WRbar		; not WRing

 ; on an interrupt, check the set pins
 ; to debounce, require 4 successive clicks
 ; ra7 and ra6 are active low
 btfsc mswitch			; if mswitch isn't being pushed
 goto mclrcheckh		; clear mscnt, check hswitch
 incf mscnt,f			; increment minute count
 movlw 0x08			;
 xorwf mscnt,w			;
 btfsc STATUS,Z			; if mscnt == 0x08
 goto dominute			; increment the minute
 goto checkh			; else check the hour switch

mclrcheckh:
 clrf mscnt			; clear the minute count
checkh:
 btfsc hswitch			; if hswitch isn't being pushed
 goto hclrcounter		; clear hscount, increment the counter
 incf hscnt,f			; increment the hour count
 movlw 0x10			;
 xorwf hscnt,w			;
 btfsc STATUS,Z			; if hscnt == 0x10
 goto dohour			; increment the hour
 goto docounter			; otherwise just do the counter

dominute:
 clrf sixt			; start the sixths count over
 clrf sec			; clear seconds
 incf min,f			; increment minutes
 movlw 0x3C			;
 xorwf min,w			;
 btfss STATUS,Z			; if minutes != 60
 goto mclrcounter		; we just increment the counter
 clrf min			; otherwise, clear the minutes
 				; fall through to hours
dohour:
 clrf sixt			; start the sixths count over
 clrf sec			; clear seconds
 incf hour,f			; increment hours
 movlw 0x0C			;
 xorwf hour,w			;
 btfss STATUS,Z			; if hours != 12
 goto hclrcounter		; we're done
 clrf hour			; else clear hours
 btfss dispAM			; if !dispAM
 goto $ + 3			; it's AM
 bcf dispAM			; else it's PM
 goto $ + 2			; done
 bsf dispAM			; (it's AM)

mclrcounter:
 clrf mscnt			; clear minute counter
hclrcounter:
 clrf hscnt			; clear the hour switch counter
docounter:
 bcf INTCON,T0IF		; clear the interrupt flag

 movlw 0xFF			; 0xFF makes tmr0 wrap
 movwf TMR0			; on the 1st timer event
				; this gives us a 60Hz rate
 incf sixt,f			; increment sixtieths counter
 movlw 0x3C			;
 xorwf sixt,w			;
 btfss STATUS,Z			; if sixt != 60
 goto theend			; we're done
 				; otherwise fall through into seconds
 clrf sixt			; clear sixtieths
 incf sec,f			; increment seconds
 movlw 0x3C			;
 xorwf sec,w			;
 btfss STATUS,Z			; if seconds != 60
 goto theend			; we're done
 				; otherwise fall through into minutes
 clrf sec			; clear seconds
 incf min,f			; increment minutes
 movlw 0x3C			;
 xorwf min,w			;
 btfss STATUS,Z			; if minutes != 60
 goto theend			; we're done
 				; otherwise fall through into hours
 clrf min			; clear minutes
 incf hour,f			; increment hour
 movlw 0x0C			;
 xorwf hour,w			;
 btfss STATUS,Z			; if hours != 12
 goto theend			; done
 clrf hour			; else clear hours
 btfss dispAM			; if !dispAM
 goto $ + 3			; it's AM
 bcf dispAM			; else it's PM
 goto $ + 2			; done
 bsf dispAM			; (it's AM)

theend:
 ;swapf tsave,w			; load saved status
 ;movwf STATUS			; into status
 ;swapf wsave,f			; use swapf to load because it does not
 ;swapf wsave,w			; affect the status register.
 
 bsf INTCON,GIE			; turn on interrupts
 goto mainloop			; refresh
