#!/usr/bin/perl

@coords = <STDIN>;
chomp @coords;

$pos = 0;
$blank = 1;

print "d$ARGV[0]:\n";
print " beamoff\n";

for ($i=0;$i<=$#coords;$i++)
{
	if ($coords[$i] =~ /^p/)
	{
		print " beamoff\n";
		$blank = 1;
	}
	else
	{
		($x,$y)=split(' ',$coords[$i]);
		$xdiff = $x - $pos;
		$ydiff = $y - $x;
		$pos = $y;

		print "; $x,$y -> $xdiff,$ydiff\n";
	
		if ($xdiff < 0) { print " addlw 0x" . substr(sprintf("%2.2x\n",$xdiff),6); }
		elsif ($xdiff > 0) { print " addlw 0x" . sprintf("%2.2x\n",$xdiff); }
		else { print " ; addlw 0x00\n"; }

		print " call writeX\n";
	
		if ($ydiff < 0) { print " addlw 0x" . substr(sprintf("%2.2x\n",$ydiff),6); }
		elsif ($ydiff > 0) { print " addlw 0x" . sprintf("%2.2x\n",$ydiff); }
		else { print " ; addlw 0x00\n"; }

		print " call writeY\n";
		if ($blank) { $blank = 0; print " beamon\n"; }
	}
}

print " return\n";
