 RADIX hex
 processor p16f628a
 LIST p=p16f628a
 LIST n=0
 LIST r=hex
 LIST st=on
 LIST f=inhx8m
 include  p16f628a.inc
 __CONFIG _BODEN_ON & _CP_OFF & _DATA_CP_OFF & _PWRTE_ON & _WDT_OFF & _LVP_OFF & _MCLRE_ON & _INTRC_OSC_NOCLKOUT

tsave	EQU 0x61
wsave	EQU 0x62
isAM	EQU 0x63
dsave	EQU 0x64
hsave	EQU 0x65
msave	EQU 0x66
ssave	EQU 0x67
mscnt	EQU 0x68
hscnt	EQU 0x69
rotn	EQU 0x6a
baselen	EQU 0x6b
linelen	EQU 0x6c
count	EQU 0x6d
xsave	EQU 0x6e
ysave	EQU 0x6f
Ydelp	EQU 0x70
Ydelm	EQU 0x71
sixt	EQU 0x72
hour	EQU 0x73
min	EQU 0x74
sec	EQU 0x75
xoff	EQU 0x76
yoff	EQU 0x77
xl	EQU 0x78
yl	EQU 0x79
xh	EQU 0x7a
yh	EQU 0x7b
sign	EQU 0x7c
hand	EQU 0x7d
temp	EQU 0x7e
hcenter	EQU 0x7f

; DAC control bits
#define	XbarY PORTA,0x00
#define LDbar PORTA,0x01
#define WRbar PORTA,0x02
#define BLbar PORTA,0x03
#define Xsign sign,0x00
#define Ysign sign,0x01
#define Xssgn sign,0x02
#define Yssgn sign,0x03
#define mswitch PORTA,0x07
#define hswitch PORTA,0x06
#define dispAM isAM,0x00

beamon	macro
	call onbeam
 endm

beamoff	macro
	bcf BLbar
 endm

wrX	macro
	movwf PORTB
	bcf XbarY
	strbWR
 endm

wrY	macro
	movwf PORTB
	bsf XbarY
	strbWR
 endm

strbWR	macro
	bcf WRbar
	bsf WRbar
 endm

strbLD	macro
	bcf LDbar
	bsf LDbar
 endm
	
 ORG 0x00
; initial setup
 bcf STATUS,RP0			; bank 0
 bcf STATUS,RP1			; ...
 clrf PORTA			; clear port A
 goto $ + 0x02			; (jump over the interrupt vector)
 goto intrh			; (interrupt vector)
 movlw 0x07			; move 0x07...
 movwf CMCON			; ...into cmcon to turn off comparators
 bsf STATUS,RP0			; bank 1
 bsf PCON,OSCF			; osc=4MHz
 movlw 0xF0			; a0, a1, a2, and a3
 movwf TRISA			; are outputs
 clrf TRISB			; portb is all output
 bcf STATUS,RP0			; bank 0
 movlw 0xFF			; load -1
 movwf TMR0			; into tmr0
 clrf hand			; clear hand
 clrf min			; clear min
 movlw 0x80			; put 0x80
 movwf hcenter			; in hcenter
 bsf WRbar			; not writing
 bsf LDbar			; not loading
 bsf XbarY			; Y
 bcf INTCON,T0IF		; clear interrupt flag
 bsf INTCON,T0IE		; enable timer interrupt
 bsf INTCON,GIE			; enable interrupts

 clrf hour
 clrf min
 clrf sec
 clrf sixt
 clrf mscnt
 clrf hscnt
 clrf dsave

mainloop:
 ; save off the hours and minutes
 movf hour,w			; load hour
 movwf hsave			; save
 movf min,w			; load minute
 movwf msave			; save
 movf sec,w			; load seconds
 movwf ssave			; save

 movf hsave,w			; load hsave
 btfsc STATUS,Z			; if hsave==0
 movlw 0x0C			; it's 12

 ; at this point, we have correctly set the AM/PM and 
 ; have a number between 1 and 12 in w
 movwf dsave			; save it just in case
 movlw 0xF6			; add -10
 addwf dsave,w			; to hsave
 btfss STATUS,C			; if we didn't carry
 goto nextdigit			; we're <10, so display 2nd digit
 				; otherwise we carried, so display a 1
 movwf dsave			; save second digit
 movlw 0x58			; y offset
 movwf Ydelp			; in ydelp
 movlw 0xA8			; -1*yoff
 movwf Ydelm			; in ydelm
 movlw 0x58			; move 0x58 into w
 call d1			; write a 1

nextdigit:
 movlw 0x44			; set yoff
 movwf Ydelp			;
 movlw 0xBC			; set -yoff
 movwf Ydelm			;
 movlw 0x6C			; set xoff
 movf dsave,f			;
 btfss STATUS,Z			; w==0?
 goto $ + 3			; no
 call d0			; draw a zero
 goto docolon			; done with this digit
 decfsz dsave,f			; decrement
 goto $ + 3			; not zero
 call d1			; draw a one
 goto docolon			; done with this digit
 decfsz dsave,f			; decrement
 goto $ + 3			; not zero
 call d2			; draw a one
 goto docolon			; done with this digit
 decfsz dsave,f			; decrement
 goto $ + 3			; not zero
 call d3			; draw a one
 goto docolon			; done with this digit
 decfsz dsave,f			; decrement
 goto $ + 3			; not zero
 call d4			; draw a one
 goto docolon			; done with this digit
 decfsz dsave,f			; decrement
 goto $ + 3			; not zero
 call d5			; draw a one
 goto docolon			; done with this digit
 decfsz dsave,f			; decrement
 goto $ + 3			; not zero
 call d6			; draw a one
 goto docolon			; done with this digit
 decfsz dsave,f			; decrement
 goto $ + 3			; not zero
 call d7			; draw a one
 goto docolon			; done with this digit
 decfsz dsave,f			; decrement
 goto $ + 3			; not zero
 call d8			; draw a one
 goto docolon			; done with this digit
 call d9			; draw a one

docolon:
 movlw 0x30			; set yoff
 movwf Ydelp			;
 movlw 0xD0			; set -yoff
 movwf Ydelm			;
 movlw 0x80			; xoff
 call dcharc			; draw the colon

 movlw 0x1C			; set yoff
 movwf Ydelp			;
 movlw 0xE4			; set -yoff
 movwf Ydelm			;
 movf msave,w			; load minutes
 movwf dsave			; save off
 movlw 0xF6			; add -10
 addwf dsave,f			; to minutes
 btfsc STATUS,C			; if we carried
 goto $ + 4			; keep going
 movlw 0x94			; xoff
 call d0			; otherwise it's 0
 goto dominc2			; next digit
 addwf dsave,f			; min = min-10
 btfsc STATUS,C			; if we carried
 goto $ + 4			; keep going
 movlw 0x94			; xoff
 call d1			; it's 1
 goto dominc2			; next digit
 addwf dsave,f			; min = min-10
 btfsc STATUS,C			; if we carried
 goto $ + 4			; keep going
 movlw 0x94			; xoff
 call d2			; it's 2
 goto dominc2			; next digit
 addwf dsave,f			; min = min-10
 btfsc STATUS,C			; if we carried
 goto $ + 4			; keep going
 movlw 0x94			; xoff
 call d3			; it's 3
 goto dominc2			; next digit
 addwf dsave,f			; min = min-10
 btfsc STATUS,C			; if we carried
 goto $ + 4			; keep going
 movlw 0x94			; xoff
 call d4			; it's 4
 goto dominc2			; next digit
 addwf dsave,f			; min = min-10
 movlw 0x94			; xoff
 call d5			; it's 5

dominc2:
 movlw 0x0a			; add 10
 addwf dsave,f			; back to dsave
 movlw 0x08			; set yoff
 movwf Ydelp			;
 movlw 0xF8			; set -yoff
 movwf Ydelm
 movlw 0xA8			; xoff
 movf dsave,f			;
 btfss STATUS,Z			; if it's not zero
 goto $ + 3			; keep going
 call d0			; draw 0
 goto drawXM			; draw am/pm
 decfsz dsave,f			; decrement; is it zero?
 goto $ + 3			; no
 call d1			; draw 1
 goto drawXM			; draw am/pm
 decfsz dsave,f			; decrement; is it zero?
 goto $ + 3			; no
 call d2			; draw 2
 goto drawXM			; draw am/pm
 decfsz dsave,f			; decrement; is it zero?
 goto $ + 3			; no
 call d3			; draw 3
 goto drawXM			; draw am/pm
 decfsz dsave,f			; decrement; is it zero?
 goto $ + 3			; no
 call d4			; draw 4
 goto drawXM			; draw am/pm
 decfsz dsave,f			; decrement; is it zero?
 goto $ + 3			; no
 call d5			; draw 5
 goto drawXM			; draw am/pm
 decfsz dsave,f			; decrement; is it zero?
 goto $ + 3			; no
 call d6			; draw 6
 goto drawXM			; draw am/pm
 decfsz dsave,f			; decrement; is it zero?
 goto $ + 3			; no
 call d7			; draw 7
 goto drawXM			; draw am/pm
 decfsz dsave,f			; decrement; is it zero?
 goto $ + 3			; no
 call d8			; draw 8
 goto drawXM			; draw am/pm
 call d9			; draw 9

drawXM:
 movlw 0xF4			; yoff
 movwf Ydelp			;
 movlw 0x0C			; -yoff
 movwf Ydelm			;
 movlw 0xBC			; xoff
 btfsc dispAM			; dispAM?
 goto $ + 3			; yes: skip ahead
 call dcharp			; no: display p
 goto $ + 2			; then the clock face
 call dchara			; display a

 clrf Ydelp			; yoff
 clrf Ydelm			; -yoff
 movlw 0x80			; xoff
 call dcharf			; display the clock face

 movf msave,w			; load minutes
 movwf hand			; into hand
 movlw 0x80			; center
 movwf xsave
 movwf ysave
 movlw 0x05			; base length
 movwf baselen			;
 movlw 0x1E			; line length
 movwf linelen			;
 call domarrow			; minute hand

 rlf hsave,w			; hsave * 2
 movwf hand			; into hand
 rlf hand,w			; hand * 2
 andlw 0xFC			; mask bottom
 addwf hsave,w			; add hsave
 movwf hand			; hand = hsave*5
 rrf msave,w
 movwf temp
 rrf temp,w
 andlw 0x3F
 movwf temp
 movlw 0xFD
 addwf temp,f
 btfss STATUS,C
 goto $ + 3
 incf hand,f
 goto $ - 5
 movlw 0x80
 movwf xsave
 movwf ysave
 movlw 0x08			; base length
 movwf baselen			;
 movlw 0x0F			; line length
 movwf linelen			;
 call doharrow			; hour hand

 movf ssave,w			; load seconds
 movwf hand			; write to hand
 movlw 0x80			; x posn
 movwf xsave			;
 movlw 0x40			; y posn
 movwf ysave			; 
 movlw 0x08			; line length
 movwf linelen			;
 call doline			; do line
 
 beamoff
 nop
 goto $ - 1

writeX:
 movwf PORTB
 bcf XbarY
 bcf WRbar
 bsf WRbar
 addwf Ydelp,w
 return
 
writeY:
 movwf PORTB
 bsf XbarY
 bcf WRbar
 bsf WRbar
 bcf LDbar
 bsf LDbar
 addwf Ydelm,w
 return

onbeam:
 movwf wsave		; save w
 movlw 0x18		; delay for slewing
 addlw 0xFF		; w=w-1
 btfsc STATUS,C		; if we carried
 goto $ - 2		; repeat
 movf wsave,w		; else bring back w
 bsf BLbar		; turn on beam
 return			; done

 include hires/0.asm
 include hires/1.asm
 include hires/2.asm
 include hires/3.asm
 include hires/4.asm
 include hires/5.asm
 include hires/6.asm
 include hires/7.asm
 include hires/8.asm
 include hires/9.asm
 include hires/a.asm
 include hires/p.asm
 include hires/c.asm
 include hires/s.asm
 include hires/f.asm
 include doarrow.asm
 include intrh.asm

 END
